//
// (c) 2020 wesolutions GmbH
// All rights reserved
//

import QtQuick 2.3

import wesual.Controls 1.0
import wesual.data.Core 1.0

BaseStringEditor {
    id : editor

    text : document ? getFormattedPrice() : ""
    width : 60

    Connections {
        target : document
        onPricesChanged : {
            editor.text = Qt.binding(
                  function() {
                      return editor.getFormattedPrice();
                  });
        }
    }

    onEditingFinished : {
        var price = text.replace(/,/g, ".");

        // price was not modified or user input price with wrong format
        if (isNaN(price)) {
            return;
        }

        document.beginRecordChanges();
        document.setPrice(document.context.country, price)
        document.endRecordChanges();
    }

    function getFormattedPrice() {
        var price  = document.getPrice(document.context.country);
        var locale = Qt.locale(document.language);
        return price.toLocaleString(locale);
    }
}
